#include <stdio.h>
#include <stdlib.h>
#include <CUnit/Basic.h>
#include <stdbool.h>
#include "copieLiberationComparaisonInt.c"
#include "../avl.c"

int init_suite_success(void) { 
  return 0; 
}

int clean_suite_success(void) { 
  return 0; 
}

bool arbres_egaux(AB_ArbreBinaire ab1, AB_ArbreBinaire ab2) {
  if (AB_estVide(ab1) && AB_estVide(ab2)) {
    return true;
  } else if (!AB_estVide(ab1) && !AB_estVide(ab2)) {
    return *(int*)AB_obtenirElement(ab1) == *(int*)AB_obtenirElement(ab2) && arbres_egaux(AB_obtenirFilsGauche(ab1), AB_obtenirFilsGauche(ab2)) && arbres_egaux(AB_obtenirFilsDroit(ab1), AB_obtenirFilsDroit(ab2));
  } else {
    return false;
  }
}

AVL_ArbreBinaireRecherche avl_5() {
  int r=5;
  return AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_15() {
  int r=15;
  return AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_10_5() {
  AVL_ArbreBinaireRecherche filsGauche;
  int r=10, g=5;
  filsGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &g, CLCI_copier);
  return AB_creerRacine(filsGauche, AB_arbreBinaire(), &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_10_15() {
  AVL_ArbreBinaireRecherche filsDroit;
  int r=10, d=15;
  filsDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &d, CLCI_copier);
  return AB_creerRacine(AB_arbreBinaire(), filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_15_10_5() {
  AVL_ArbreBinaireRecherche filsGauche, filsGaucheGauche;;
  int r=15, g=10, gg=5;
  filsGaucheGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &gg, CLCI_copier);
  filsGauche = AB_creerRacine(filsGaucheGauche, AB_arbreBinaire(), &g, CLCI_copier);
  return AB_creerRacine(filsGauche, AB_arbreBinaire(), &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_5_10_15() {
  AVL_ArbreBinaireRecherche filsDroit, filsDroitDroit;
  int r=5, d=10, dd=15;
  filsDroitDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dd, CLCI_copier);
  filsDroit = AB_creerRacine(AB_arbreBinaire(), filsDroitDroit, &d, CLCI_copier);
  return AB_creerRacine(AB_arbreBinaire(), filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_10_5_15() {
  AVL_ArbreBinaireRecherche filsGauche, filsDroit;
  int r=10, g=5, d=15;
  filsGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &g, CLCI_copier);
  filsDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &d, CLCI_copier);
  return AB_creerRacine(filsGauche, filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_10_5_7() {
  AVL_ArbreBinaireRecherche filsGauche, filsGaucheDroit;
  int r=10, g=5, gd=7;
  filsGaucheDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &gd, CLCI_copier);
  filsGauche = AB_creerRacine(AB_arbreBinaire(), filsGaucheDroit, &g, CLCI_copier);
  return AB_creerRacine(filsGauche, AB_arbreBinaire(), &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_7_5_10() {
  AVL_ArbreBinaireRecherche filsGauche, filsDroit;
  int r=7, g=5, d=10;
  filsGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &g, CLCI_copier);
  filsDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &d, CLCI_copier);
  return AB_creerRacine(filsGauche, filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_5_7_6() {
  AVL_ArbreBinaireRecherche filsDroit, filsDroitGauche;
  int r=5, g=7, dg=6;
  filsDroitGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dg, CLCI_copier);
  filsDroit = AB_creerRacine(filsDroitGauche, AB_arbreBinaire(), &g, CLCI_copier);
  return AB_creerRacine(AB_arbreBinaire(), filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_6_5_7() {
  AVL_ArbreBinaireRecherche filsGauche, filsDroit;
  int r=6, g=5, d=7;
  filsGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &g, CLCI_copier);
  filsDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &d, CLCI_copier);
  return AB_creerRacine(filsGauche, filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_8_5_10_7() {
  AVL_ArbreBinaireRecherche filsGauche, filsDroit, filsDroitGauche;
  int r=8, g=5, d=10, dg=7;
  filsDroitGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dg, CLCI_copier);
  filsGauche = AB_creerRacine(AB_arbreBinaire(), filsDroitGauche, &g, CLCI_copier);
  filsDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &d, CLCI_copier);
  return AB_creerRacine(filsGauche, filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_10_5_20_7_15_25_18() {
  AVL_ArbreBinaireRecherche filsGauche, filsDroit, filsDroitGauche, filsDroitDroit, filsGaucheDroit, filsDroitGaucheDroit;
  int r=10, g=5, d=20, dg=7, gd=15, dd=25, dgd=18;
  filsDroitGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dg, CLCI_copier);
  filsGauche = AB_creerRacine(AB_arbreBinaire(), filsDroitGauche, &g, CLCI_copier);
  filsDroitGaucheDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dgd, CLCI_copier);
  filsGaucheDroit = AB_creerRacine(AB_arbreBinaire(), filsDroitGaucheDroit, &gd, CLCI_copier);
  filsDroitDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dd, CLCI_copier);
  filsDroit = AB_creerRacine(filsGaucheDroit, filsDroitDroit, &d, CLCI_copier);
  return AB_creerRacine(filsGauche, filsDroit, &r, CLCI_copier);
}

AVL_ArbreBinaireRecherche avl_15_7_20_5_18_25() {
  AVL_ArbreBinaireRecherche filsGauche, filsDroit, filsGaucheGauche, filsGaucheDroit, filsDroitDroit;
  int r=15, g=7, d=20, gg=5, gd=18, dd=25;
  filsGaucheGauche = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &gg, CLCI_copier);
  filsGauche = AB_creerRacine(filsGaucheGauche, AB_arbreBinaire(), &g, CLCI_copier);
  filsGaucheDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &gd, CLCI_copier);
  filsDroitDroit = AB_creerRacine(AB_arbreBinaire(), AB_arbreBinaire(), &dd, CLCI_copier);
  filsDroit = AB_creerRacine(filsGaucheDroit, filsDroitDroit, &d, CLCI_copier);
  return AB_creerRacine(filsGauche, filsDroit, &r, CLCI_copier);
}  
  
void test_bn_arbre_vide_est_vide() {
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  CU_ASSERT_TRUE(AVL_estVide(abr));
}

void test_bn_inserer_racine_obtenirElement() {
  int valeurAttendue = 5;
  AVL_ArbreBinaireRecherche abr = avl_5();
  CU_ASSERT_EQUAL(*(int*)AVL_obtenirElement(abr), valeurAttendue);
  AVL_detruire(&abr, CLCI_liberer);
}

void test_inserer_sans_rotation() {
  AVL_ArbreBinaireRecherche arbreAttendu = avl_10_5_15();
  int i;
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  i=10;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=5;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=15;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  CU_ASSERT_TRUE(arbres_egaux(abr, arbreAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&arbreAttendu, CLCI_liberer);
}

void test_bn_inserer_avec_simple_rotation_gauche() {
  AVL_ArbreBinaireRecherche arbreAttendu = avl_10_5_15();
  int i;
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  i=5;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=10;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=15;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  CU_ASSERT_TRUE(arbres_egaux(abr, arbreAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&arbreAttendu, CLCI_liberer);
}

void test_bn_inserer_avec_simple_rotation_droite() {
   AVL_ArbreBinaireRecherche arbreAttendu = avl_10_5_15();
  int i;
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  i=15;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=10;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=5;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  CU_ASSERT_TRUE(arbres_egaux(abr, arbreAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&arbreAttendu, CLCI_liberer);
} 

void test_bn_inserer_avec_double_rotation_droite() {
  AVL_ArbreBinaireRecherche arbreAttendu = avl_7_5_10();
  int i;
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  i=10;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=5;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=7;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  CU_ASSERT_TRUE(arbres_egaux(abr, arbreAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&arbreAttendu, CLCI_liberer);
}

void test_bn_inserer_avec_double_rotation_gauche() {
  AVL_ArbreBinaireRecherche arbreAttendu = avl_6_5_7();
  int i;
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  i=5;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=7;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  i=6;
  AVL_inserer(&abr, (void*)&i, CLCI_copier, CLCI_comparer);
  CU_ASSERT_TRUE(arbres_egaux(abr, arbreAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&arbreAttendu, CLCI_liberer);
}

void test_bn_supprimer_non_present() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_15();
  AVL_ArbreBinaireRecherche abrAttendu = avl_10_5_15();
  int i = 7;
  AVL_supprimer(&abr, (void*)&i, CLCI_copier, CLCI_comparer, CLCI_liberer);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bn_supprimer_feuille() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_15();
  AVL_ArbreBinaireRecherche abrAttendu = avl_10_5();
  int i = 15;
  AVL_supprimer(&abr, (void*)&i, CLCI_copier, CLCI_comparer, CLCI_liberer);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bn_supprimer_avec_fils_gauche_vide() {
  AVL_ArbreBinaireRecherche abr = avl_10_15();
  AVL_ArbreBinaireRecherche abrAttendu = avl_15();
  int i = 10;
  AVL_supprimer(&abr, (void*)&i, CLCI_copier, CLCI_comparer, CLCI_liberer);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bn_supprimer_avec_fils_droit_vide() {
  AVL_ArbreBinaireRecherche abr = avl_10_15();
  AVL_ArbreBinaireRecherche abrAttendu = avl_15();
  int i = 10;
  AVL_supprimer(&abr, (void*)&i, CLCI_copier, CLCI_comparer, CLCI_liberer);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bn_supprimer_avec_fils_gauche_et_droit_sans_reequilibrage() {
  AVL_ArbreBinaireRecherche abr = avl_8_5_10_7();
  AVL_ArbreBinaireRecherche abrAttendu = avl_7_5_10();
  int i = 8;
  AVL_supprimer(&abr, (void*)&i, CLCI_copier, CLCI_comparer, CLCI_liberer);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bn_supprimer_avec_fils_gauche_et_droit_avec_reequilibrage() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_20_7_15_25_18();
  AVL_ArbreBinaireRecherche abrAttendu = avl_15_7_20_5_18_25();
  int i = 10;
  AVL_supprimer(&abr, (void*)&i, CLCI_copier, CLCI_comparer, CLCI_liberer);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bb_hauteur_arbre_vide() {
  AVL_ArbreBinaireRecherche abr = AVL_arbreBinaireRecherche();
  CU_ASSERT_EQUAL(AVL_hauteur(abr), -1);
}

void test_bb_hauteur_10_5_15() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_15();
  CU_ASSERT_EQUAL(AVL_hauteur(abr), 1);
  AVL_detruire(&abr, CLCI_liberer);
}

void test_bb_hauteur_5_10_15() {
  AVL_ArbreBinaireRecherche abr = avl_5_10_15();
  CU_ASSERT_EQUAL(AVL_hauteur(abr), 2);
  AVL_detruire(&abr, CLCI_liberer);
}

void test_bb_obtenir_element() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_15();
  CU_ASSERT_EQUAL(AVL_obtenirElement(abr), AB_obtenirElement(abr));
  AVL_detruire(&abr, CLCI_liberer);
}

void test_bb_obtenir_fils_gauche() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_15();
  CU_ASSERT_EQUAL(AVL_obtenirFilsGauche(abr), AB_obtenirFilsGauche(abr));
  AVL_detruire(&abr, CLCI_liberer);
}

void test_bb_obtenir_fils_droit() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_15();
  CU_ASSERT_EQUAL(AVL_obtenirFilsDroit(abr), AB_obtenirFilsDroit(abr));
  AVL_detruire(&abr, CLCI_liberer);
}

void test_bb_simple_rotation_droite() {
  AVL_ArbreBinaireRecherche abr = avl_15_10_5();
  AVL_ArbreBinaireRecherche abrAttendu = avl_10_5_15();
  AVL_faireSimpleRotationADroite(&abr);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bb_simple_rotation_gauche() {
  AVL_ArbreBinaireRecherche abr = avl_5_10_15();
  AVL_ArbreBinaireRecherche abrAttendu = avl_10_5_15();
  AVL_faireSimpleRotationAGauche(&abr);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bb_double_rotation_droite() {
  AVL_ArbreBinaireRecherche abr = avl_10_5_7();
  AVL_ArbreBinaireRecherche abrAttendu = avl_7_5_10();
  AVL_faireDoubleRotationADroite(&abr);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

void test_bb_double_rotation_gauche() {
  AVL_ArbreBinaireRecherche abr = avl_5_7_6();
  AVL_ArbreBinaireRecherche abrAttendu = avl_6_5_7();
  AVL_faireDoubleRotationAGauche(&abr);
  CU_ASSERT_TRUE(arbres_egaux(abr, abrAttendu));
  AVL_detruire(&abr, CLCI_liberer);
  AVL_detruire(&abrAttendu, CLCI_liberer);
}

int main(int argc, char** argv){
  CU_pSuite pSuiteBoiteNoire = NULL;
  CU_pSuite pSuiteBoiteBlanche = NULL;
  
  /* initialisation du registre de tests */
  if (CUE_SUCCESS != CU_initialize_registry())
    return CU_get_error();

  /* ajout d'une suite de tests boite noire */
  pSuiteBoiteNoire = CU_add_suite("Tests boite noire du type AVL_ArbreBinaireRecherche", init_suite_success, clean_suite_success);
  if (NULL == pSuiteBoiteNoire) {
    CU_cleanup_registry();
    return CU_get_error();
  }
  /* Ajout des tests à la suite de tests boite noire */
  if (
      (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_arbreBinaireRecherche est vide", test_bn_arbre_vide_est_vide))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_arbreBinaireRecherche obtenir element à la racine", test_bn_inserer_racine_obtenirElement))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_inserer sans rotation", test_inserer_sans_rotation))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_inserer avec simple rotation droite", test_bn_inserer_avec_simple_rotation_droite))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_inserer avec simple rotation gauche", test_bn_inserer_avec_simple_rotation_gauche))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_inserer avec double rotation droite", test_bn_inserer_avec_double_rotation_droite))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_inserer avec double rotation gauche", test_bn_inserer_avec_double_rotation_gauche))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_supprimer non présent", test_bn_supprimer_non_present))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_supprimer feuille", test_bn_supprimer_feuille))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_supprimer avec fils gauche vide", test_bn_supprimer_avec_fils_gauche_vide))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_supprimer avec fils droit vide", test_bn_supprimer_avec_fils_droit_vide))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_supprimer avec fils gauche et droit sans rééquilibrage", test_bn_supprimer_avec_fils_gauche_et_droit_sans_reequilibrage))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "AVL_supprimer avec fils gauche et droit avec rééquilibrage", test_bn_supprimer_avec_fils_gauche_et_droit_avec_reequilibrage))
      )
    {
      CU_cleanup_registry();
      return CU_get_error();
    }

  /* ajout d'une suite de tests boite blanche */
  pSuiteBoiteBlanche = CU_add_suite("Tests boite blanche du type AVL_ArbreBinaireRecherche", init_suite_success, clean_suite_success);
  if (NULL == pSuiteBoiteBlanche) {
    CU_cleanup_registry();
    return CU_get_error();
  }
  /* Ajout des tests à la suite de tests boite blanche */
  if (
      (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_arbreBinaireRecherche est de hauteur -1", test_bb_hauteur_arbre_vide))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "Arbre non vide hauteur 1/2", test_bb_hauteur_10_5_15))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "Arbre non vide hauteur 2/2", test_bb_hauteur_5_10_15))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_obtenirElement", test_bb_obtenir_element))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_obtenirFilsGauche", test_bb_obtenir_fils_gauche))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_obtenirFilsDroit", test_bb_obtenir_fils_droit))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_faireSimpleRotationADroite", test_bb_simple_rotation_droite))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_faireSimpleRotationAGauche", test_bb_simple_rotation_gauche))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_faireDoubleRotationADroite", test_bb_double_rotation_droite))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "AVL_faireDoubleRotationAGauche", test_bb_double_rotation_gauche))
      )
    {
      CU_cleanup_registry();
      return CU_get_error();
    }
  
  /* Lancement des tests */
  CU_basic_set_mode(CU_BRM_VERBOSE);
  CU_basic_run_tests();
  printf("\n");
  CU_basic_show_failures(CU_get_failure_list());
  printf("\n\n");

  /* Nettoyage du registre */
  CU_cleanup_registry();
  return CU_get_error();
}
