#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "arbreBinaire.h"

AB_ArbreBinaire AB_arbreBinaire() {
  errno=0;
  return NULL;
}

bool AB_estVide(AB_ArbreBinaire a) {
  return a==NULL;
}

AB_ArbreBinaire AB_creerRacine(AB_ArbreBinaire fg,
			       AB_ArbreBinaire fd,
			       void* pElement,
			       CLC_FonctionCopier copierElement) {
  AB_ArbreBinaire a=(AB_ArbreBinaire)malloc(sizeof(AB_Noeud));
  if (a==NULL) {
    errno=AB_ERREUR_MEMOIRE;
    return NULL;
  }
  a->lElement=copierElement(pElement);
  if (a->lElement==NULL) {
    free(a);
    errno=AB_ERREUR_MEMOIRE;
    return NULL;
  }
  a->filsGauche=fg;
  a->filsDroit=fd;
  return a;
}

void* AB_obtenirElement(AB_ArbreBinaire a) {
  assert(!AB_estVide(a));
  return a->lElement;
}

AB_ArbreBinaire AB_obtenirFilsGauche(AB_ArbreBinaire a) {
  assert(!AB_estVide(a));
  errno=0;
  return a->filsGauche;
}

AB_ArbreBinaire AB_obtenirFilsDroit(AB_ArbreBinaire a) {
  assert(!AB_estVide(a));
  errno=0;
  return a->filsDroit;
}

void AB_fixerFilsGauche(AB_ArbreBinaire *pa, AB_ArbreBinaire fg) {
  assert(!AB_estVide(*pa));
  errno=0;
  (*pa)->filsGauche=fg;
}

void AB_fixerFilsDroit(AB_ArbreBinaire *pa, AB_ArbreBinaire fd) {
  assert(!AB_estVide(*pa));
  errno=0;
  (*pa)->filsDroit=fd;
}

void AB_fixerElement(AB_ArbreBinaire *pa,
		     void *pElement,
		     CLC_FonctionCopier copierElement,
		     CLC_FonctionLiberer libererElement) {
  assert(!AB_estVide(*pa));
  errno=0;
  void *temp=copierElement(pElement);
  if (temp==NULL) {
    errno=AB_ERREUR_MEMOIRE;
    return;
  }
  libererElement((*pa)->lElement);
  (*pa)->lElement=temp;
}

void AB_supprimerRacine(AB_ArbreBinaire *pa,
			AB_ArbreBinaire *pfg,
			AB_ArbreBinaire *pfd,
			CLC_FonctionLiberer libererElement) {
  assert(!AB_estVide(*pa));
  errno=0;
  libererElement((*pa)->lElement);
  *pfg=(*pa)->filsGauche;
  *pfd=(*pa)->filsDroit;
  free(*pa);
  *pa=NULL;
}

void AB_supprimer(AB_ArbreBinaire *pa, CLC_FonctionLiberer libererElement) {
  AB_ArbreBinaire fg,fd;
  errno=0;
  if (AB_estVide(*pa)) {
    return;
  }
  AB_supprimerRacine(pa,&fg,&fd,libererElement);
  AB_supprimer(&fg,libererElement);
  AB_supprimer(&fd,libererElement);
}
  
AB_ArbreBinaire AB_copier(AB_ArbreBinaire a,
			  CLC_FonctionCopier copierElement,
			  CLC_FonctionLiberer libererElement) {
  AB_ArbreBinaire fg, fd;
  errno=0;
  if (AB_estVide(a)) {
    return AB_arbreBinaire();
  }
  fg=AB_copier(AB_obtenirFilsGauche(a),copierElement,libererElement);
  if (errno!=0) {
    return AB_arbreBinaire();
  }
  fd=AB_copier(AB_obtenirFilsDroit(a),copierElement,libererElement);
  if (errno!=0) {
    AB_supprimer(&fg,libererElement);
    return AB_arbreBinaire();
  }
  return AB_creerRacine(fg,fd,AB_obtenirElement(a),copierElement);
}
  
int AB_egaux(AB_ArbreBinaire a1,AB_ArbreBinaire a2,CLC_FonctionComparer comparerElement) {
  errno=0;
  if (AB_estVide(a1) && AB_estVide(a2)) {
    return true;
  }
  if (AB_estVide(a1) || AB_estVide(a2)) {
    return false;
  }
  if (!comparerElement(AB_obtenirElement(a1),AB_obtenirElement(a2))) {
    return false;
  }
  if (!AB_egaux(AB_obtenirFilsGauche(a1),AB_obtenirFilsGauche(a2),comparerElement)) {
    return false;
  }
  if (!AB_egaux(AB_obtenirFilsDroit(a1),AB_obtenirFilsDroit(a2),comparerElement)) {
    return false;
  }
  return true;
}
