/**
 * \file copieLiberationComparaisonInt.h
 * \brief Fichier d'entête qui définit la signature de fonctions permettant d'utiliser des entiers dans une collection générique
*/

#ifndef __COPIE_LIBERATION_COMPARAISON_INT__
#define __COPIE_LIBERATION_COMPARAISON_INT__

/**
 * \fn void* CLCI_copier(void* pInt)
 * \brief Fonction qui permet de copier un entier dans une collection
 * \param pInt pointeur vers l'entier à copier
 * \return void* 
*/
void* CLCI_copier(void* pInt);

/**
 * \fn void CLCI_liberer(void* pInt)
 * \brief Fonction qui permet de supprimer un entier d'une collection
 * \param pInt pointeur vers l'entier à supprimer
*/
void CLCI_liberer(void* pInt);

/**
 * \fn int CLCI_comparer(void* pInt1,void* pInt2)
 * \brief Fonction qui permet de comparer deux entiers d'une collection. 
 *  - Si les deux entiers sont égaux, la fonction retourne 0
 *  - Si le premier entier est inférieur au second, la fonction retourne une valeur négative
 *  - Si le premier entier est supérieur au second, la fonction retourne une valeur positive
 * \param pInt1 pointeur vers le premier entier à comparer
 * \param pInt2 pointeur vers le second entier à comparer
 * \return int
*/
int CLCI_comparer(void* pInt1,void* pInt2);

#endif
