/**
 * \file allocationLiberationComparaison.h
 * \brief Fichier d'entête qui définit des types de fonctions permettant de gérer la copie, la libération et la comparaison d'éléments dans une collection générique
 * \author N. Delestre
 * \version 2.0
 * \date 23/11/2015
 */


#ifndef __COPIE_LIBERATION_COMPARAISON__
#define __COPIE_LIBERATION_COMPARAISON__

/**
 * \brief Type de fonction qui permet de copier un élément dans une collection
 * \param pElement un pointeur vers l'élément à copier dans la collection
*/
typedef void* (*CLC_FonctionCopier) (void* pElement);

/**
 * \brief Type de fonction qui permet de supprimer un élément d'une collection
 * \param pElement un pointeur vers l'élément à supprimer de la collection
*/
typedef void (*CLC_FonctionLiberer) (void* pElement);

/**
 * \brief Type de fonction qui permet de comparer deux éléments d'une collection. 
 * Si les deux éléments sont égaux, la fonction retourne 0
 * Si le premier élément est inférieur au second, la fonction retourne une valeur négative
 * Si le premier élément est supérieur au second, la fonction retourne une valeur positive
 * \param pElement1 un pointeur vers le premier élément à comparer
 * \param pElement2 un pointeur vers le second élément à comparer
*/
typedef int (*CLC_FonctionComparer) (void* pElement1,void* pElement2);
#endif
