#ifndef __SERPENT_H__
#define __SERPENT_H__

#include "listeChainee.h"
#include "coordonnee.h"
#include "direction.h"

typedef struct {
  LC_ListeChainee tete;
  LC_ListeChainee queue;
  unsigned int longueur;
  unsigned int accroissement;
  D_Direction direction;
  unsigned int largeurTerrain;
  unsigned int hauteurTerrain;
} S_Serpent;

/**
   @brief crer un serpent
   @param positionInitialeQueue coordonne de la queue du serpent
   @param longueurInitiale longueur initiale du serpent (>=1)
   @param directionInitiale direction initiale du serpent
   @param largeurTerrain largeur du terrain
   @param hauteurTerrain hauteur du terrain
   @return le serpent cr
**/
S_Serpent S_serpent(C_Coordonnee positionInitialeQueue,
		    unsigned int longueurInitiale,
		    D_Direction directionInitiale,
		    unsigned int largeurTerrain,
		    unsigned int hauteurTerrain);

/**
   @brief coordonnes de la tte du serpent
   @param serpent le serpent
   @return coordonne de la tte du serpent
**/
C_Coordonnee S_positionTete(S_Serpent serpent);

/**
   @brief coordonnes de la queue du serpent
   @param serpent le serpent
   @return coordonne de la queue du serpent
**/
C_Coordonnee S_positionQueue(S_Serpent serpent);

/**
   @brief fait avancer le serpent
   @param pserpent pointeur vers le serpent
   @note le serpent avance dans la direction courante et il peut grandir si l'accroissement est > 0 (dcrmente l'accroissement dans ce cas). Si le serpent atteint le bord du terrain, il rapparat de l'autre ct.
**/
void S_avancer(S_Serpent* pserpent);

/**
   @brief retourne la direction courante du serpent
   @param serpent le serpent
   @return la direction courante du serpent
**/
D_Direction S_direction(S_Serpent serpent);

/**
   @brief change la direction du serpent
   @param pserpent pointeur vers le serpent
   @param nouvelleDirection nouvelle direction du serpent
   @return 0 si la direction a t change, -1 sinon
   @note la nouvelle direction doit tre diffrente de la direction courante et ne pas tre l'oppose
**/
int S_changerDirection(S_Serpent* pserpent, D_Direction nouvelleDirection);

/**
   @brief fait grandir le serpent
   @param pserpent pointeur vers le serpent
   @param longueur nombre d'avancements pendant lesquels le serpent grandit
**/
void S_accroissement(S_Serpent* pserpent, unsigned int longueur);

/**
   @brief retourne la longueur du serpent
   @param serpent le serpent
   @return la longueur du serpent
**/
unsigned int S_longueur(S_Serpent serpent);

/**
   @brief teste si le serpent se mord la queue
   @param serpent le serpent
   @return true si le serpent se mord la queue, false sinon
**/
bool S_seMord(S_Serpent serpent);

/**
   @brief teste si une coordonne est occupe par le serpent
   @param serpent le serpent
   @param coord la coordonne
   @return true si la coordonne est occupe par le serpent, false sinon
**/
bool S_estUneCoordonneeDuSerpent(S_Serpent serpent, C_Coordonnee coord);

/**
   @brief retourne les coordonnes du serpent sous forme de tableau dynamique
   @param serpent le serpent
   @return un tableau dynamique contenant les coordonnes du serpent (de la queue  la tte)
   @note la mmoire alloue pour le tableau doit tre libre par l'appelant avec free()
   @note la premire coordonne du tableau est celle de la queue et la dernire est celle de la tte
**/
C_Coordonnee* S_coordonneeDuSerpent(S_Serpent serpent);

/**
   @brief libre la mmoire alloue dynamiquement pour le serpent
   @param pserpent pointeur vers le serpent  librer
**/
void S_liberer(S_Serpent* pserpent);
#endif

  
