#ifndef __COORDONNEE_H__
#define __COORDONNEE_H__

#include <stdbool.h>
#include "direction.h"

/**
   @brief structure reprsentant une coordonne d'un cran de jeu avec un terrain de jeu rectangulairetorique (la coordonne voisine d'un bord est de l'autre ct du terrain)
   (0,0) tant le coin suprieur gauche de l'cran
**/
typedef struct {
    unsigned int x;
    unsigned int y;
} C_Coordonnee;

/**
   @brief crer une coordonne
   @param x abscisse
   @param y ordonne
   @return la coordonne cre
**/
C_Coordonnee C_coordonnee(unsigned int x, unsigned int y);

/**
   @brief obtenir l'abscisse d'une coordonne
   @param coord la coordonne
   @return l'abscisse
**/
unsigned int C_abscisse(C_Coordonnee coord);

/**
   @brief obtenir l'ordonne d'une coordonne
   @param coord la coordonne
   @return l'ordonne
**/
unsigned int C_ordonnee(C_Coordonnee coord);

/**
   @brief obtenir la coordonne voisine dans une direction donne
   @param coord la coordonne
   @param direction la direction
   @param largeurTerrain la largeur du terrain de jeu
   @param hauteurTerrain la hauteur du terrain de jeu
   @return la coordonne voisine
**/
C_Coordonnee C_coordonneeVoisine(C_Coordonnee coord,
				 D_Direction direction,
				 unsigned int largeurTerrain,
				 unsigned int hauteurTerrain);

/**
   @brief tester l'galit de deux coordonnes
   @param coord1 la premire coordonne
   @param coord2 la deuxime coordonne
   @return true si les coordonnes sont gales, false sinon
**/
bool C_sontEgales(C_Coordonnee coord1, C_Coordonnee coord2);

/**
   @brief ralise une copie (allocation dynamique) d'une coordonne compatible avec les fonctions de gestion mmoire gnriques des sdd
   @param coord la coordonne
   @return un pointeur vers la copie de la coordonne
**/
void* C_copier(void* pcoord);

/**
   @brief libre une coordonne alloue dynamiquement
   @param pcoord pointeur vers la coordonne  librer
**/
void C_liberer(void* pcoord);

/**
   @brief compare deux coordonnes pour les fonctions de gestion mmoire gnriques des sdd
   @param pcoord1 pointeur vers la premire coordonne
   @param pcoord2 pointeur vers la deuxime coordonne
   @return 0 si les coordonnes sont gales, 1 sinon
**/
int C_comparer(const void* pcoord1, const void* pcoord2);

#endif
