import pytest
from moteur_de_recherche_web.representation_ensembliste import index_en_index_inverse, \
    documents_contenant_mot, et, ou, non


@pytest.fixture
def index():
    return {
        "doc1": ["mot1", "mot2", "mot3"],
        "doc2": ["mot2", "mot3", "mot4", "mot5"],
        "doc3": ["mot3", "mot4", "mot5"],
        "doc4": ["mot1", "mot3", "mot4","mot5"],
    }

@pytest.fixture
def index_inverse():
    return {
        "mot1": {"doc1", "doc4"},
        "mot2": {"doc1", "doc2"},
        "mot3": {"doc1", "doc2", "doc3", "doc4"},
        "mot4": {"doc2", "doc3", "doc4"},
        "mot5": {"doc2", "doc3", "doc4"},
    }

def test_index_en_index_inverse(index, index_inverse):
    assert index_en_index_inverse(index) == index_inverse

def test_documents_contenant_mot(index_inverse):
    assert documents_contenant_mot(index_inverse, "mot1") == {"doc1", "doc4"}
    assert documents_contenant_mot(index_inverse, "mot2") == {"doc1", "doc2"}
    assert documents_contenant_mot(index_inverse, "mot3") == {"doc1", "doc2", "doc3", "doc4"}
    assert documents_contenant_mot(index_inverse, "mot4") == {"doc2", "doc3", "doc4"}
    assert documents_contenant_mot(index_inverse, "mot5") == {"doc2", "doc3", "doc4"}

def test_et(index_inverse):
    assert et({"doc1", "doc2"}, {"doc2", "doc3"}) == {"doc2"}
    assert et({"doc1", "doc2"}, {"doc3", "doc4"}) == set()

def test_ou(index_inverse):
    assert ou({"doc1", "doc2"}, {"doc2", "doc3"}) == {"doc1", "doc2", "doc3"}
    assert ou({"doc1", "doc2"}, {"doc3", "doc4"}) == {"doc1", "doc2", "doc3", "doc4"}
    assert ou({"doc1", "doc2"}, {"doc4", "doc5"}) == {"doc1", "doc2", "doc4", "doc5"}

def test_non(index_inverse):
    assert non({"doc1", "doc2", "doc3", "doc4"}, {"doc1", "doc2", "doc3", "doc4", "doc5"}) == {"doc5"}
    assert non({"doc1", "doc2", "doc3", "doc4"}, {"doc1", "doc2", "doc3", "doc4"}) == set()
    assert non(set(), {"doc1", "doc2", "doc3", "doc4"}) == {"doc1", "doc2", "doc3", "doc4"}
    assert non({"doc1", "doc2", "doc3", "doc4"}, set()) == set()