#!/usr/bin/env python3
import random
from .question_reponses import QuestionReponses

class QuestionReponsesAddition(QuestionReponses):
    def __init__(self, operande_gauche: int, operande_droite: int):
        self._operande_gauche = operande_gauche
        self._operande_droite = operande_droite
        super().__init__([str(operande_gauche + operande_droite),
                          str(operande_gauche + operande_droite + 1),
                          str(operande_gauche + operande_droite - 1),
                          str(operande_gauche + operande_droite + 2)
                          ],
                         0)

    @property
    def domaine(self) -> str:
        return "Mathématiques"

    @property
    def question(self) -> str:
        return f"Combien font {self._operande_gauche} + {self._operande_droite} ?"

class QuestionReponsesFactory:
    """Fabrique de questions sur les additions.
    Cette classe implémente le protocole question_reponses.QuestionReponsesFactory.
    """
    def question_reponses(self) -> QuestionReponses:
        operande_gauche = random.randint(0, 100)
        operande_droite = random.randint(0, 100)
        return QuestionReponsesAddition(operande_gauche, operande_droite)

