#include <stdio.h>
#include <CUnit/Basic.h>
#include <string.h>
#include <stdbool.h>
#include "calc.h"
#include "calc.c"

#define EPSILON 0.0001
#define LONGUEUR_MAX_CHAINE 100

int float_egaux(float a, float b, float epsilon) {
    return fabs(a - b) < epsilon;
}

int init_suite_success(void) { 
  return 0; 
}

int clean_suite_success(void) { 
  return 0; 
}

void test_estChifre1(void){
  CU_ASSERT_TRUE(CALC_estUnChiffre('1'));
}

void test_estChiffre2(void){
  CU_ASSERT_FALSE(CALC_estUnChiffre('a'));
}

void test_reconnaitreParentheseOuvrante1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreParentheseOuvrante("(",0,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 1);
  CU_ASSERT_TRUE(syntaxiquementOK);  
}

void test_reconnaitreParentheseOuvrante2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreParentheseOuvrante("{",0,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 0);
  CU_ASSERT_FALSE(syntaxiquementOK);    
}

void test_reconnaitreParentheseFermante1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreParentheseFermante(")",0,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 1);
  CU_ASSERT_TRUE(syntaxiquementOK);
}

void test_reconnaitreParentheseFermante2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreParentheseFermante("}",0,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 0);
  CU_ASSERT_FALSE(syntaxiquementOK);  
}

void test_reconnaitreVirgule1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreVirgule("12.1",2,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 3);
  CU_ASSERT_TRUE(syntaxiquementOK);
}

void test_reconnaitreVirgule2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreVirgule("12,1",2,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 3);
  CU_ASSERT_TRUE(syntaxiquementOK);
}

void test_reconnaitreVirgule3(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_reconnaitreVirgule("12",2,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_FALSE(syntaxiquementOK);
}

void test_reconnaitreSuiteChiffres1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  char suiteChiffres[LONGUEUR_MAX_CHAINE];
  CALC_reconnaitreSuiteChiffres("123",0,suiteChiffres,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 3);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_STRING_EQUAL("123", suiteChiffres);
}

void test_reconnaitreSuiteChiffres2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  char suiteChiffres[LONGUEUR_MAX_CHAINE];  
  CALC_reconnaitreSuiteChiffres("0123",0,suiteChiffres,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 4);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_STRING_EQUAL("0123", suiteChiffres);
}

void test_reconnaitreSuiteChiffres3(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  char suiteChiffres[LONGUEUR_MAX_CHAINE];
  CALC_reconnaitreSuiteChiffres("a123",0,suiteChiffres,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_FALSE(syntaxiquementOK);
}

void test_reconnaitreNombre0(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  float nb;
  CALC_reconnaitreNombre("123",0,&nb,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 3);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(nb == 123.);
}

void test_reconnaitreNombre1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  float nb;
  CALC_reconnaitreNombre("123,25",0,&nb,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 6);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(nb == 123.25);
}

void test_reconnaitreNombre2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  float nb;
  CALC_reconnaitreNombre("0123.25",0,&nb,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 7);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(nb == 123.25);
}

void test_reconnaitreNombre3(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  float nb;
  CALC_reconnaitreNombre("123.",0,&nb,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 4);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(nb == 123.);
}

void test_reconnaitreNombre4(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  float nb;
  CALC_reconnaitreNombre(".25",0,&nb,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 3);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(nb == .25);
}

void test_reconnaitreOperateur1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_Operateur op;
  CALC_reconnaitreOperateur("+",0,&op,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 1);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(op == addition);
}

void test_reconnaitreOperateur2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_Operateur op;
  CALC_reconnaitreOperateur("-",0,&op,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 1);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(op == soustraction);
}

void test_reconnaitreOperateur3(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_Operateur op;
  CALC_reconnaitreOperateur("*",0,&op,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 1);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(op == multiplication);
}

void test_reconnaitreOperateur4(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_Operateur op;
  CALC_reconnaitreOperateur("/",0,&op,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 1);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(op == division);
}

void test_reconnaitreOperateur5(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK;
  CALC_Operateur op;
  CALC_reconnaitreOperateur("#",0,&op,&prochainDebut,&syntaxiquementOK);
  CU_ASSERT_FALSE(syntaxiquementOK);
}

void test_reconnaitreOperande1(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK, semantiquementOK;
  float nb;
  CALC_reconnaitreOperande("125",0,&nb,&prochainDebut,&syntaxiquementOK,&semantiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 3);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(semantiquementOK);
  CU_ASSERT_TRUE(nb == 125.);
}

void test_reconnaitreOperande2(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK, semantiquementOK;
  float nb;
  CALC_reconnaitreOperande("(125+24.25)",0,&nb,&prochainDebut,&syntaxiquementOK,&semantiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 11);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(semantiquementOK);
  CU_ASSERT_TRUE(nb == 149.25);
}

void test_reconnaitreOperande3(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK, semantiquementOK;
  float nb;
  CALC_reconnaitreOperande("(125-24.25)",0,&nb,&prochainDebut,&syntaxiquementOK,&semantiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 11);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(semantiquementOK);
  CU_ASSERT_TRUE(nb == 100.75);
}

void test_reconnaitreOperande4(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK, semantiquementOK;
  float nb;
  CALC_reconnaitreOperande("(125*24.25)",0,&nb,&prochainDebut,&syntaxiquementOK,&semantiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 11);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(semantiquementOK);
  CU_ASSERT_TRUE(nb == 3031.25);
}

void test_reconnaitreOperande5(void){
  unsigned int prochainDebut;
  bool syntaxiquementOK, semantiquementOK;
  float nb;
  CALC_reconnaitreOperande("(125/25)",0,&nb,&prochainDebut,&syntaxiquementOK,&semantiquementOK);
  CU_ASSERT_TRUE(prochainDebut == 8);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_TRUE(semantiquementOK);
  CU_ASSERT_TRUE(nb == 5.);
}

void test_calculer_division_par_zero(void){
  float resultatCalcule;
  bool syntaxiquementOK, semantiquementOK;
  CALC_calculer("25/0", &resultatCalcule, &syntaxiquementOK, &semantiquementOK);
  CU_ASSERT_TRUE(syntaxiquementOK);
  CU_ASSERT_FALSE(semantiquementOK);
}

// @u:start tests_unitaires

// TODO

// @u:end tests_unitaires

int main(int argc, char* *argv){
  CU_pSuite pSuiteBoiteBlanche = NULL;
  CU_pSuite pSuiteBoiteNoire = NULL;

  /* initialisation du registre de tests */
  if (CUE_SUCCESS != CU_initialize_registry())
    return CU_get_error();

  /* ajout d'une suite de test */
  pSuiteBoiteBlanche = CU_add_suite("Tests (boite blanche)", init_suite_success, clean_suite_success);
  if (NULL == pSuiteBoiteBlanche) {
    CU_cleanup_registry();
    return CU_get_error();
  }

  pSuiteBoiteNoire = CU_add_suite("Tests (boite noire)", init_suite_success, clean_suite_success);
  if (NULL == pSuiteBoiteNoire) {
    CU_cleanup_registry();
    return CU_get_error();
  }  

  /* Ajout des tests � la suite de tests boite noire */
  if ((NULL == CU_add_test(pSuiteBoiteBlanche, "'1' est un chiffre", test_estChifre1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'a' n'est pas un chiffre", test_estChiffre2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'(' est une parenthese ouvrante", test_reconnaitreParentheseOuvrante1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'{' n'est pas une parenthese ouvrante", test_reconnaitreParentheseOuvrante2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "')' est une parenthese fermante", test_reconnaitreParentheseFermante1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'}' n'est pas une parenthese fermante", test_reconnaitreParentheseFermante2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'12.1' a une virgule", test_reconnaitreVirgule1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'12,1' a une virgule", test_reconnaitreVirgule2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'12' n'a pas de virgule", test_reconnaitreVirgule3))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'123' est une suite de chiffres", test_reconnaitreSuiteChiffres1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'0123' est une suite de chiffres", test_reconnaitreSuiteChiffres2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'a123' n'est pas une suite de chiffres", test_reconnaitreSuiteChiffres3))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'123' represente un nombre", test_reconnaitreNombre0))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'123,25' represente un nombre", test_reconnaitreNombre1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'0123.25' represente un nombre", test_reconnaitreNombre2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'123.' represente un nombre", test_reconnaitreNombre3))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'+' represente un operateur", test_reconnaitreOperateur1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'-' represente un operateur", test_reconnaitreOperateur2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'*' represente un operateur", test_reconnaitreOperateur3))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'/' represente un operateur", test_reconnaitreOperateur4))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'#' ne represente pas un operateur", test_reconnaitreOperateur4))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'125' represente une operande", test_reconnaitreOperande1))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'(125+24.25)' represente une operande", test_reconnaitreOperande2))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'(125-24.25)' represente une operande", test_reconnaitreOperande3))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'(125*24.25)' represente une operande", test_reconnaitreOperande4))
      || (NULL == CU_add_test(pSuiteBoiteBlanche, "'(25/10)' represente une operande", test_reconnaitreOperande5))
      || (NULL == CU_add_test(pSuiteBoiteNoire, "Division par zero", test_calculer_division_par_zero))
// @u:start ajout_tests_unitaires

// TODO

// @u:end ajout_tests_unitaires
      )
    {
      CU_cleanup_registry();
      return CU_get_error();
    }

  /* Lancement des tests */
  CU_basic_set_mode(CU_BRM_VERBOSE);
  CU_basic_run_tests();
  printf("\n");
  CU_basic_show_failures(CU_get_failure_list());
  printf("\n\n");

  /* Nettoyage du registre */
  CU_cleanup_registry();
  return CU_get_error();
}
