
pytest_output=$(pytest -q)
nombre_tests_valides=$(echo "$pytest_output" | grep -oE '([0-9]+) passed' | grep -oE '[0-9]+')
if [ -z "$nombre_tests_valides" ]; then
    nombre_tests_valides=0
fi
nombre_tests_echoues=$(echo "$pytest_output" | grep -oE '([0-9]+) failed' | grep -oE '[0-9]+')
if [ -z "$nombre_tests_echoues" ]; then
    nombre_tests_echoues=0
fi
nombre_tests=$(($nombre_tests_valides + $nombre_tests_echoues))
pytest_score=$(echo "scale=2; 10 * $nombre_tests_valides / $nombre_tests" | bc)

pylint_output=$(pylint tas.py)
pylint_score=$(echo "$pylint_output" | grep -oE 'Your code has been rated at ([0-9]+\.[0-9]+)' | grep -oE '[0-9]+\.[0-9]+' | head -n 1)

note=$(echo "scale=2; 2*(0.3 * $pylint_score + 0.7 * $pytest_score)" | bc)
echo $note
