import pytest
from tas import Tas, TasVideErreur, ElementNonComparableErreur

def test_creer_tas_vide():
    tas = Tas()
    assert tas.est_vide

def test_ajouter_depuis_tas_vide():
    tas = Tas()
    tas.ajouter(3)
    assert not tas.est_vide
    assert tas.element == 3

def test_ajouter_depuis_tas_non_vide():
    tas = Tas()
    tas.ajouter(3)
    tas.ajouter(5)
    assert tas.element == 5

def test_ajouter_non_comparable_avec_ceux_presents():
    tas = Tas()
    tas.ajouter(3)
    tas.ajouter(5)
    with pytest.raises(ElementNonComparableErreur):
        tas.ajouter("a")

def tets_ajouter_non_intrinsequement_comparable():
    tas = Tas()
    with pytest.raises(ElementNonComparableErreur):
        tas.ajouter(2+3j)

def test_element_present():
    tas = Tas()
    tas.ajouter(3)
    tas.ajouter(5)
    assert tas.element == 5

def test_element_tas_vide_exception():
    tas = Tas()
    with pytest.raises(TasVideErreur):
        tas.element

def test_len():
    tas = Tas()
    tas.ajouter(3)
    tas.ajouter(5)
    tas.ajouter(2)
    assert len(tas) == 3

def test_creer_tas_a_partir_d_elements():
    tas = Tas([3, 5, 2, 8, 7])
    assert tas.element == 8
    assert len(tas) == 5

def test_creer_tas_a_partir_d_elements_avec_cle():
    tas = Tas([3, 5, 2, 8, 7], cle=lambda x: -x)
    assert tas.element == 2

def test_in():
    tas = Tas([3, 5, 2, 8, 7])
    assert 5 in tas
    assert 4 not in tas

def test_retirer():
    tas = Tas([3, 5, 2, 8, 7])
    assert tas.retirer() == 8
    assert len(tas) == 4
    assert tas.element == 7

def test_retirer_tas_vide_exception():
    tas = Tas()
    with pytest.raises(TasVideErreur):
        tas.retirer()

def test_str():
    tas = Tas([3, 5, 2, 8, 7, 1])
    assert str(tas) == "8\n 7\n  3\n  5\n 2\n  1\n"

def test_repr():
    tas = Tas([3, 5, 2, 8, 7, 1])
    assert repr(tas) == f"<Tas object {id(tas)}>"

def test_iteration():
    tas = Tas([3, 5, 2, 8, 7, 1])
    assert list(tas) == [8, 7, 5, 3, 2, 1]
