import pytest
import ast

def tas_ast():
    with open('tas.py') as f:
        return ast.parse(f.read())

def classe(nom):
    l_ast = tas_ast()
    for node in l_ast.body:
        if isinstance(node, ast.ClassDef) and node.name == nom:
            return node
    return None

def methode(classe, nom):
    for node in classe.body:
        if isinstance(node, ast.FunctionDef) and node.name == nom:
            return node
    return None

def type_retour_methode(methode):
    return methode.returns

def parametre_formel(methode, nom):
    for node in methode.args.args:
        if node.arg == nom:
            return node
    return None

def propriete(classe, nom):
    for node in classe.body:
        if isinstance(node, ast.FunctionDef) and node.name == nom and "property" in [decorator.id for decorator in node.decorator_list]:
            return node
    return None

def annotation_parametre_formel(parametre_formel):
    return parametre_formel.annotation

def test_init():
    tas = classe('Tas')
    init = methode(tas, '__init__')
    assert init is not None, "La méthode __init__ n'existe pas"
    assert parametre_formel(init, 'elements') is not None, "Le premier argument de la méthode __init__ doit s'appeler elements"
    assert annotation_parametre_formel(parametre_formel(init, 'elements')).value.id == 'Iterable', "Le premier argument de la méthode __init__ doit être de type Iterable"
    assert annotation_parametre_formel(parametre_formel(init, 'elements')).slice.id == 'T', "Le premier argument de la méthode __init__ doit être de type Iterable[T]"
    assert parametre_formel(init, 'cle') is not None, "Le deuxième argument de la méthode __init__ doit s'appeler cle"
    assert annotation_parametre_formel(parametre_formel(init, 'cle')).id == 'Callable', "Le deuxième argument de la méthode __init__ doit être de type Callable"

def test_propriete_est_vide():
    tas = classe('Tas')
    est_vide = propriete(tas, 'est_vide')
    assert est_vide is not None, "La propriété est_vide n'existe pas"
    assert type_retour_methode(est_vide).id == 'bool', "La propriété est_vide doit retourner un booléen"

def test_methode_ajouter():
    tas = classe('Tas')
    ajouter = methode(tas, 'ajouter')
    assert ajouter is not None, "La méthode ajouter n'existe pas"
    assert len(ajouter.args.args) == 2, "La méthode ajouter doit prendre un argument en plus de self"
    assert parametre_formel(ajouter, 'element') is not None, "Le deuxième argument de la méthode ajouter doit s'appeler element"
    assert annotation_parametre_formel(parametre_formel(ajouter, 'element')).id == 'T', "La méthode ajouter doit prendre un argument de type T"
    assert type_retour_methode(ajouter).value == None, "La méthode ajouter doit retourner None"

def test_methode_retirer():
    tas = classe('Tas')
    retirer = methode(tas, 'retirer')
    assert retirer is not None, "La méthode retirer n'existe pas"
    assert len(retirer.args.args) == 1, "La méthode retirer ne doit prendre aucun argument en plus de self"
    assert type_retour_methode(retirer).id == 'T', "La méthode retirer doit retourner un élément de type T"

def test_propriete_element():
    tas = classe('Tas')
    element = propriete(tas, 'element')
    assert element is not None, "La propriété element n'existe pas"
    assert type_retour_methode(element).id == 'T', "La propriété element doit retourner un élément de type T"

def test_len():
    tas = classe('Tas')
    len_ = methode(tas, '__len__')
    assert len_ is not None, "La méthode __len__ n'existe pas"
    assert type_retour_methode(len_).id == 'int', "La méthode __len__ doit retourner un entier"

def test_str():
    tas = classe('Tas')
    str_ = methode(tas, '__str__')
    assert str_ is not None, "La méthode __str__ n'existe pas"
    assert type_retour_methode(str_).id == 'str', "La méthode __str__ doit retourner une chaîne de caractères"

def test_repr():
    tas = classe('Tas')
    repr_ = methode(tas, '__repr__')
    assert repr_ is not None, "La méthode __repr__ n'existe pas"
    assert type_retour_methode(repr_).id == 'str', "La méthode __repr__ doit retourner une chaîne de caractères"

def test_in():
    tas = classe('Tas')
    in_ = methode(tas, '__contains__')
    assert in_ is not None, "La méthode __contains__ n'existe pas"
    assert len(in_.args.args) == 2, "La méthode __contains__ doit prendre un argument en plus de self"
    assert parametre_formel(in_, 'element') is not None, "Le deuxième argument de la méthode __contains__ doit s'appeler element"
    assert annotation_parametre_formel(parametre_formel(in_, 'element')).id == 'T', "La méthode __contains__ doit prendre un argument de type T"
    assert type_retour_methode(in_).id == 'bool', "La méthode __contains__ doit retourner un booléen"

def test_iter():
    tas = classe('Tas')
    iter_ = methode(tas, '__iter__')
    assert iter_ is not None, "La méthode __iter__ n'existe pas"
    assert type_retour_methode(iter_).slice.id == 'T', "La méthode __iter__ doit retourner un itérable d'éléments de type T"