import pytest

from moteur_de_recherche_web.visiteur_modele_booleen import visiter
from moteur_de_recherche_web.analyseur import Et, Ou, Non

@pytest.fixture
def index_inverse():
    return {
        "mot1": {"doc1", "doc4"},
        "mot2": {"doc1", "doc2"},
        "mot3": {"doc1", "doc2", "doc3", "doc4"},
        "mot4": {"doc2", "doc3", "doc4"},
        "mot5": {"doc2", "doc3", "doc4"},
    }

def test_visiter_mot(index_inverse):
    ast = "mot1"
    assert visiter(ast, index_inverse) == {"doc1", "doc4"}

def test_visiter_et(index_inverse):
    ast = Et("mot1", "mot2")
    assert visiter(ast, index_inverse) == {"doc1"}

def test_visiter_ou(index_inverse):
    ast = Ou("mot1", "mot2")
    assert visiter(ast, index_inverse) == {"doc1", "doc2", "doc4"}

def test_visiter_non(index_inverse):
    ast = Non("mot1")
    assert visiter(ast, index_inverse) == {"doc2", "doc3"}