from moteur_de_recherche_web.analyseur import analyser_requete, Et, Ou, Non

def test_analyser_requete():
    requete = "mot1 ET mot2"
    assert analyser_requete(requete) == Et("mot1", "mot2")
    requete = "mot1 OU mot2"
    assert analyser_requete(requete) == Ou("mot1", "mot2")
    requete = "NON mot1"
    assert analyser_requete(requete) == Non("mot1")
    requete = "(mot1 ET mot2) OU NON mot3"
    assert analyser_requete(requete) == Ou(Et("mot1", "mot2"), Non("mot3"))
    requete = "(mot1 ET mot2) OU (mot3 ET mot4)"
    assert analyser_requete(requete) == Ou(Et("mot1", "mot2"), Et("mot3", "mot4"))
    requete = "(mot1 ET mot2) OU (mot3 ET mot4 ET mot5)"
    assert analyser_requete(requete) == Ou(Et("mot1", "mot2"), Et(Et("mot3", "mot4"), "mot5"))