"""Module implémentant de design pattern Visteur pour visiter un AST représentant 
    une recherche booléenne et retourner les simalarités de documents au regard de cette recherche."""

from functools import singledispatch
import logging
import math

from .analyseur import Et, Ou, Non
from .representation_ensembliste import documents_contenant_mot, et, ou, non
from .representation_vectorielle_tfidf import RepresentationVectorielle

@singledispatch
def visiter(ast: Et, document: str, representation_vectorielle: RepresentationVectorielle) -> float:
    """ Visite de l'AST en tant que noeud Et.
        Retourne l'intersection des ensembles. 
    """
    logging.debug(f"Visite de l'AST en tant que Et : {ast}")
    # A remplacer
    return 0.0


@visiter.register
def _(ast: Ou, document: str, representation_vectorielle: RepresentationVectorielle) -> float:
    """ Visite de l'AST en tant que noeud Ou.
        Sinon retourne l'union des ensembles.
    """
    logging.debug(f"Visite de l'AST en tant que Ou : {ast}")
    # A remplacer
    return 0.0
                                                        
@visiter.register
def _(ast: Non, document: str, representation_vectorielle: RepresentationVectorielle) -> float:
    """ Visite de l'AST en tant que noeud Non.
        Retourne l'ensemble car ce n'est pas au niveau de ce noeud qu'on fait la négation.
    """
    logging.debug(f"Visite de l'AST en tant que Non : {ast}")
    # A remplacer
    return 0.0

@visiter.register
def _(ast: str, document: str, representation_vectorielle: RepresentationVectorielle) -> float:
    """ Visite de l'AST en tant que noeud Mot.
        Retourne la valeur tf-idf du mot dans le document.
    """
    logging.debug(f"Visite de l'AST en tant que Mot : {ast}")
    # A remplacer
    return 0.0
