"""Module contenant la classe asbtraite QuestionReponses et l'interface/le protocole QuestionReponsesFactory."""
import random
from typing import Protocol
from abc import ABC, abstractmethod

class QuestionReponses(ABC):
    """Classe abstraite pour les questions à choix multiples."""

    def __init__(self, reponses: list[str], indice_bonne_reponse: int):
        """
        Initialise une instance de QuestionReponses.
        Les réponses sont mélangées aléatoirement tout en maintenant l'indice de la bonne réponse.
        """
        self._reponses = reponses
        self._indice_bonne_reponse = indice_bonne_reponse

        # Mélanger les réponses
        for i in range(len(self._reponses)):
            nouvelle_pos = random.randint(0, len(self._reponses) - 1)
            self._reponses[i], self._reponses[nouvelle_pos] = (
                self._reponses[nouvelle_pos],
                self._reponses[i],
            )
            # Mettre à jour l'indice de la bonne réponse si nécessaire
            if self._indice_bonne_reponse == i:
                self._indice_bonne_reponse = nouvelle_pos
            elif self._indice_bonne_reponse == nouvelle_pos:
                self._indice_bonne_reponse = i

    @property
    @abstractmethod
    def domaine(self) -> str:
        """Retourne le domaine de la question."""
        pass

    @property
    @abstractmethod
    def question(self) -> str:
        """Retourne la question."""
        pass

    @property
    def reponses(self) -> list[str]:
        """Retourne les réponses."""
        return self._reponses

    @property
    def indice_bonne_reponse(self) -> int:
        """Retourne l'indice de la bonne réponse."""
        return self._indice_bonne_reponse

class QuestionReponsesFactory(Protocol):
    """Protocole pour les fabriques de questions à choix multiples."""

    def question_reponses(self) -> QuestionReponses:
        """Retourne une instance de QuestionReponses."""
        pass
