"""Module pour des questions à choix multiples utilisant Wikidata."""
from abc import ABC, abstractmethod
from rdflib import URIRef
from .sparql import QuestionReponsesFactorySparql


# class QuestionReponsesWikidata(QuestionReponsesSparql):
#     """Classe abstraite pour les questions à choix multiples utilisant Wikidata."""

#     def __init__(self, question: str, reponses: list[str], bonne_reponse: int):
#         super().__init__(question, reponses, bonne_reponse)

#     @staticmethod
#     def prefixes() -> str:
#         """Retourne les préfixes standards utiles pour faire une requête SPARQL sur Wikidata."""
#         return QuestionReponsesSparql.prefixes() + """PREFIX wd: <http://www.wikidata.org/entity/>
#         PREFIX wdt: <http://www.wikidata.org/prop/direct/>
#         PREFIX wikibase: <http://wikiba.se/ontology/>
#         PREFIX p: <http://www.wikidata.org/prop/>
#         PREFIX v: <http://www.wikidata.org/prop/statement/>
#         PREFIX q: <http://www.wikidata.org/prop/qualifier/>
#         """

#     @staticmethod
#     def uri_entree_sparql() -> URIRef:
#         """Retourne l'entrée SPAQRL de Wikidata."""
#         return URIRef("https://query.wikidata.org/sparql")


class QuestionReponsesFactoryWikidata(QuestionReponsesFactorySparql):
    """Classe abstraite implémentant le protocole QuestionReponsesFactory pour les fabriques de questions à choix multiples utilisant Wikidata."""

    def prefixes(self) -> str:
        """Retourne les préfixes standards utiles pour faire une requête SPARQL sur Wikidata.
Cf. https://www.wikidata.org/wiki/EntitySchema:E49
        """
        return super().prefixes() + """PREFIX cc: <http://creativecommons.org/ns#>
PREFIX dct: <http://purl.org/dc/terms/>
PREFIX geo: <http://www.opengis.net/ont/geosparql#>
PREFIX ontolex: <http://www.w3.org/ns/lemon/ontolex#>
PREFIX owl: <http://www.w3.org/2002/07/owl#>
PREFIX p: <http://www.wikidata.org/prop/>
PREFIX pq: <http://www.wikidata.org/prop/qualifier/>
PREFIX pqn: <http://www.wikidata.org/prop/qualifier/value-normalized/>
PREFIX pqv: <http://www.wikidata.org/prop/qualifier/value/>
PREFIX pr: <http://www.wikidata.org/prop/reference/>
PREFIX prn: <http://www.wikidata.org/prop/reference/value-normalized/>
PREFIX prov: <http://www.w3.org/ns/prov#>
PREFIX prv: <http://www.wikidata.org/prop/reference/value/>
PREFIX ps: <http://www.wikidata.org/prop/statement/>
PREFIX psn: <http://www.wikidata.org/prop/statement/value-normalized/>
PREFIX psv: <http://www.wikidata.org/prop/statement/value/>
PREFIX schema: <http://schema.org/>
PREFIX skos: <http://www.w3.org/2004/02/skos/core#>
PREFIX wd: <http://www.wikidata.org/entity/>
PREFIX wdata: <http://www.wikidata.org/wiki/Special:EntityData/>
PREFIX wdno: <http://www.wikidata.org/prop/novalue/>
PREFIX wdref: <http://www.wikidata.org/reference/>
PREFIX wds: <http://www.wikidata.org/entity/statement/>
PREFIX wdt: <http://www.wikidata.org/prop/direct/>
PREFIX wdtn: <http://www.wikidata.org/prop/direct-normalized/>
PREFIX wdv: <http://www.wikidata.org/value/>
PREFIX wikibase: <http://wikiba.se/ontology#>
        """

    def uri_entree_sparql(self) -> URIRef:
        """Retourne l'entrée SPAQRL de Wikidata."""
        return URIRef("https://query.wikidata.org/sparql")
