$( document ).ready(function() {
  agent('neutre',200,300,"Bienvenue !");
  $("#name").focusin(function(){surveillance(this);});
  $("#email").focusin(function(){surveillance(this);});
  $("#message").focusin(function(){surveillance(this);});
  $("#name").keyup(function(){validate(this);});
  $("#email").keyup(function(){validate(this);});
  $("#message").keyup(function(){validate(this);});
});

function surveillance(field) {
  var top = $(field).position().top-40;
  var left = $(field).position().left+$(field).width()+20;
  if($(field).val()=="") {
    agent('neutre',top,left,"Je surveille votre saisie.");
  } else {
    validate(field);
  }
}

function agent(style,top,left,msg) {
  /* On teste si l'élément agent existe pour le créer si nécessaire */
  if ($("#agent").length==0) {
    $( "body" ).append( "<div id='agent'></div>" );
    $( "#agent").css( "z-index", "1000" );
    $( "#agent").css( "position", "absolute" );
    $( "#agent").css( "top", top+"px" );
    $( "#agent").css( "left", left+"px" );
  } else {
    $("#agent").animate({"top":top+"px", "left":left+"px"},"fast");
  }
  if (msg) {
    msg = "<span id='agent-message'>"+msg+"</span>";
  }
  /* Changement de l'image */
  switch (style) {
    case "happy": 
      $( "#agent" ).html( "<img src='Images/happy.png' />"+msg );
      $( "#agent-message").css( "background-color", "#79f056" );
      break;
    case "sad": 
      $( "#agent" ).html( "<img src='Images/sad.png' />"+msg );
      $( "#agent-message").css( "background-color", "#f66767" );
      break;
    default : 
      $( "#agent" ).html( "<img src='Images/neutre.png' />"+msg );
      $( "#agent-message").css( "background-color", "#eee" );
      break;
  }
  $( "#agent-message").css( "border", "dotted 1px grey" );
  $( "#agent-message").css( "padding", "5px" );
  $( "#agent img" ).css("vertical-align","middle");
}

function validate(field) {
  var top = $(field).position().top-40;
  var left = $(field).position().left+$(field).width()+20;
  switch ($(field).attr('id')) {
    case "name": 
    case "message": 
      if ($(field).val().trim().length>0) {
        agent('happy',top,left,"Parfait !");
      } else {
        agent('sad',top,left,"Vous devez entrer un texte !");
      }
      break;
    case "email":
      var regex = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
      if ($(field).val().trim().length>0 && regex.test($(field).val())) {
        agent('happy',top,left,"L'email est valide !");
      } else {
        agent('sad',top,left,"Vous devez entrer un email valide !");
      }
      break;
   }
}
