// import express module and create your express app
const express = require('express');
const app = express();

// set the server host and port
const port = 3000;

// endpoint executed for all requests
app.use(function (req, res, next) {
	console.log(req.url);
	// there is no response sent, we mush call next()
  	next();
});

// endpoint with a specific route
app.use('/home', function (req, res) {
	res.send('Welcome home!');
	// we sent a response, no need to call next()
});

// endpoint with a general route
app.use('/', function (req, res) {
	res.send('Hello World!');
	// we sent a response, no need to call next()
});

// run the server
app.listen(port, () => {
	// callback executed when the server is launched
	console.log(`Express app listening on port ${port}`);
});
