// import express module and create your express app
const express = require('express');
const app = express();

// enable your express app to serve static files located in "public" directory
app.use(express.static('public'));
// enable your express app to read request body (for POST requests)
app.use(express.urlencoded({ extended: true })); 

// set the server host and port
const port = 3000;

// endpoint executed for all requests
app.use(function (req, res, next) {
	console.log(req.url);
	console.log(req.method);
	console.log(req.query); // shows GET params
	console.log(req.body); // show POST params
  	next();
});

// endpoint with a specific route
app.get('/data', function (req, res) {
	res.send('GET /data');
});

// endpoint with a specific route
app.post('/data', function (req, res) {
	res.send('POST /data');
});

// run the server
app.listen(port, () => {
	// callback executed when the server is launched
	console.log(`Express app listening on port ${port}`);
});