// import express module and create your express app
const express = require('express');
const app = express();

//import the fs module
const fs = require('fs');

// set the server host and port
const port = 3000;

app.get('/', (req, res, next) => {
	fs.readFile('./file.txt', { encoding: 'utf8' }, (err, data) => {
		if (err) {
			next(err);
		} else {
			res.send(''+ data);
		}
	})
})

app.use((err, req, res, next) => {
	console.error(err.stack);
	res.status(500).send('Something broke!');
})

// run the server
app.listen(port, () => {
	// callback executed when the server is launched
	console.log(`Express app listening on port ${port}`);
});
