// import express module and create your express app
const express = require('express');
const app = express();

// enable your express app to serve static files located in "public" directory
app.use(express.static('public'));
// enable your express app to read request body (for POST requests)
app.use(express.urlencoded({ extended: true })); 

// set the server host and port
const port = 3000;

// basic root route
app.get('/', function(req, res){
	res.send('Hello world!');
  });
  
// the 404 route (always keep this as the last route)
app.get('*', function(req, res){
	res.status(404);
	//serve a static html file (can be done using express.static)
	res.sendFile("404.html", {root: "."});
});

// run the server
app.listen(port, () => {
	// callback executed when the server is launched
	console.log(`Express app listening on port ${port}`);
});