// import http module; documentation: https://nodejs.org/api/http.html
const http = require('http');
// import url module; documentation: https://nodejs.org/api/url.html
const url = require('url');

// set the server host and port
const hostname = '127.0.0.1';
const port = 3000;

// create a http server endpoint
const server = http.createServer((req, res) => {

	// read and parse the URL
	const queryObject = url.parse(req.url, true).query;

	// response status code (200 = OK)
	res.statusCode = 200;
	// response header
	res.setHeader('Content-Type', 'text/html');
	
	// set the response of your endpoint
	var doc = "<!DOCTYPE html><html><body><h1>"
	if ('nom' in queryObject) {
		doc += `Salut ${queryObject.nom}!`;
	} else {
		doc += "Salut toi!";
	}
	doc += "</h1></body></html>";
	res.end(doc);
});

// run the first server
server.listen(port, hostname, () => {
	// callback executed when the server is launched
	console.log(`Server running at http://${hostname}:${port}/`);
});

// import express module and create your express app
const express = require('express');
const app = express();
// enable your express app to serve static files located in "public" directory
app.use(express.static('public'));
app.listen(3030);
console.log(`Express running at http://${hostname}:3030/`);
