// import http module
const http = require('http');

// set the server host and port
const hostname = '127.0.0.1';
const port = 3000;

// create a http server endpoint
const server = http.createServer((req, res) => {
	// response status code (200 = OK)
	res.statusCode = 200;
	// response header
	res.setHeader('Content-Type', 'text/html');
	// set the response of your endpoint
	res.end(`<!DOCTYPE html>
			<html>
				<body>
					<h1>Hello World! (but it's in HTML)</h1>
				</body>
			</html>`);
});

// run the server
server.listen(port, hostname, () => {
	// callback executed when the server is launched
	console.log(`Server running at http://${hostname}:${port}/`);
});
