// import http module
const http = require('http');
// import url module; documentation: https://nodejs.org/api/url.html
const url = require('url');

// set the server host and port
const hostname = '127.0.0.1';
const port = 3000;

// create a http server endpoint
const server = http.createServer((req, res) => {
	
	// read and parse the URL
	const queryObject = url.parse(req.url, true).query;

	// response status code (200 = OK)
	res.statusCode = 200;
	// response header
	res.setHeader('Content-Type', 'text/plain');
	
	// set the response of your endpoint
	if ('name' in queryObject) {
		res.end(`Hey ${queryObject.name}!`);
	} else {
		res.end("Hey you!");
	}
});

// run the server
server.listen(port, hostname, () => {
	// callback executed when the server is launched
	console.log(`Server running at http://${hostname}:${port}/`);
});
