#!/usr/bin/env python3
""" Module proposant des fonctions d'IA pour jouer au puissance 4"""
import copy
import random
from plateau_puissance4 import plateau_rempli, contenu_case, \
    colonne_remplie, jouer,\
    nb_pions_alignes_horizontalement, nb_pions_alignes_verticalement, \
    nb_pions_alignes_diagonalement_SONE, nb_pions_alignes_diagonalement_NOSE, \
    HAUTEUR_PLATEAU, LARGEUR_PLATEAU, JAUNE, ROUGE, plateau_est_vide
from puissance4 import dernier_coup_gagnant

INFINI=10000000
SCORE = {1:0, 2:5, 3:20, 4: INFINI}
PROFONDEUR_MIN_MAX = 4
PROFONDEUR_ALPHA_BETA = 6


random.seed()


def obtenir_coup_aleatoire(plateau: "Plateau", couleur: "JAUNE|ROUGE") -> int:
    """Fonction qui sera redéveloppée dans le deuxième TP sur le puissance 4
Pour l'instant le choix du coup est aléatoire"""
    colonnes_non_remplies = [colonne for colonne in range(1, LARGEUR_PLATEAU)
                             if not colonne_remplie(plateau, colonne)
                             ]
    return random.choice(colonnes_non_remplies)

def obtenir_coups_possible(plateau: "Plateau") -> set:
    """Fonction qui détermine l'ensemble des coups possibles"""
    return {colonne for colonne in range(1,LARGEUR_PLATEAU+1)
            if not colonne_remplie(plateau, colonne)}

def score(plateau: "Plateau", couleur: "JAUNE|ROUGE") -> int:
    """Score d'une position pour un joueur donné"""
    res = 0
    for colonne in range(1, LARGEUR_PLATEAU+1):
        for ligne in range(1, HAUTEUR_PLATEAU+1):
            if contenu_case(plateau, colonne, ligne) == couleur:
                res = res + SCORE[nb_pions_alignes_horizontalement(plateau,colonne,ligne)]\
                    + SCORE[nb_pions_alignes_verticalement(plateau,colonne,ligne)]\
                    + SCORE[nb_pions_alignes_diagonalement_NOSE(plateau,colonne,ligne)]\
                    + SCORE[nb_pions_alignes_diagonalement_SONE(plateau,colonne,ligne)]
    return res

def evaluer(plateau: "Plateau", couleur: "JAUNE|ROUGE") -> int:
    """Évaluation d'une position pour un joueur donnée"""
    autre_couleur = JAUNE if couleur == ROUGE else ROUGE
    return score(plateau, couleur) - score(plateau, autre_couleur)


def score_d_un_coup_min_max(plateau: "Plateau",
                            couleur_courante: "JAUNE|ROUGE",
                            couleur_ia: "JAUNE|ROUGE",
                            coup: int,
                            profondeur: int) -> int:
    """Score d'un coup utilisant l'algorithme Min-Max"""
    copie_du_plateau = copy.deepcopy(plateau)
    jouer(copie_du_plateau, coup, couleur_courante)
    if dernier_coup_gagnant(copie_du_plateau, coup):
        return SCORE[4] * (1 if couleur_courante == couleur_ia else -1)
    if plateau_rempli(copie_du_plateau) or profondeur == 0:
        return evaluer(copie_du_plateau, couleur_ia)
    return min_max(copie_du_plateau,
                   JAUNE if couleur_courante == ROUGE else ROUGE,
                   couleur_ia,
                   profondeur-1)

def min_max(plateau: "Plateau",
            couleur_courante: "JAUNE|ROUGE",
            couleur_ia: "JAUNE|ROUGE",
            profondeur: int) -> int:
    """L'algorithme Min-Max"""
    coups_possibles = list(obtenir_coups_possible(plateau))
    scores = [score_d_un_coup_min_max(plateau, couleur_courante, couleur_ia, coup, profondeur) for coup in coups_possibles]
    if couleur_courante == couleur_ia:
        res = max(scores)
    else:
        res = min(scores)    
    return res


def obtenir_meilleur_coup_min_max(plateau: "Plateau", couleur: "JAUNE|ROUGE") -> int:
    """Fonction qui détermine le meilleur coup à l'aide de l'algorithme
    Min-Max"""
    if plateau_est_vide(plateau):
        return obtenir_coup_aleatoire(plateau, couleur)
    coups_possibles = list(obtenir_coups_possible(plateau))
    scores_des_coups = {coup : score_d_un_coup_min_max(plateau, couleur, couleur, coup, PROFONDEUR_MIN_MAX) for coup in coups_possibles}
    meilleur_score = max(scores_des_coups.values())
    for coup, score in scores_des_coups.items():
        if score == meilleur_score:
            return coup

def score_d_un_coup_alpha_beta(plateau: "Plateau",
                               couleur_courante: "JAUNE|ROUGE",
                               couleur_ia: "JAUNE|ROUGE",
                               coup: int,
                               profondeur: int,
                               alpha: int,
                               beta: int) -> int:
    """Score d'un coup utilisant l'algorithme Min-Max"""
    return 0

def alpha_beta(plateau: "Plateau",
               couleur_courante: "JAUNE|ROUGE",
               couleur_ia: "JAUNE|ROUGE",
               profondeur: int,
               alpha: int,
               beta: int) -> int:
    """L'algorithme Alpha-Bêta"""
    return 0

def obtenir_meilleur_coup_alpha_beta(plateau: "Plateau", couleur: "JAUNE|ROUGE") -> int:
    """Fonction qui détermine le meilleur coup à l'aide de l'algorithme
        Alpha-Bêta"""
    # à remplacer
    return obtenir_coup_aleatoire(plateau, couleur)

def tests():
    from plateau_puissance4 import plateau_vide
    from puissance4_ihm_txt import plateau_en_chaine
    plateau = plateau_vide()
    jouer(plateau, 1, JAUNE)
    jouer(plateau, 3, ROUGE)
    jouer(plateau, 1, JAUNE)
    jouer(plateau, 1, ROUGE)
    jouer(plateau, 1, JAUNE)
    jouer(plateau, 3, ROUGE)
    jouer(plateau, 1, JAUNE)
    jouer(plateau, 3, ROUGE)
    print(plateau_en_chaine(plateau))
    print(obtenir_coups_possible(plateau))
    print(obtenir_meilleur_coup_min_max(plateau, JAUNE))

if __name__ == "__main__":
    tests()
