#/usr/bin/env python3
""" Un module d'outils sur les listes """

from typing import Sequence, Any, TypeVar, Callable, List

T = TypeVar('T')
R = TypeVar('R')

def nb_occurences(sequence: Sequence[T], element_a_compter: T) -> int:
    pass

def mettre_en_majuscule(sequence: Sequence[str]) -> List[str]:
    pass

def retirer(sequence: Sequence[T], element_a_retirer: T) -> List[Any]:
    pass

def appliquer(sequence: Sequence[T], fonction: Callable[[T], R] = lambda x: x) -> List[R]:
    pass

def decouper_en_listes_meme_longueur(sequence: Sequence[T], longueur=1) -> List[List[T]]:
    pass

if __name__ == "__main__":
    from ok_ko import ok_ko
    def test_nb_occurences():
        return nb_occurences([1, 3, 2, 3, 1, 4, 1, 2, 5, 2, 3], 2) == 3
    def test_mettre_en_majuscule():
        return mettre_en_majuscule(["a", "B", "aB"]) == ["A", "B", "AB"]
    def test_retirer():
        return retirer([1, 3, 2, 3, 1, 4, 1, 2, 5, 2, 3], 2) == [1, 3, 3, 1, 4, 1, 5, 3]
    def test_appliquer_1():
        return appliquer([1, 2, 3]) == [1, 2, 3]
    def test_appliquer_2():
        return appliquer([1, 2, 3], lambda x: x**2) == [1, 4, 9]
    def test_decouper_en_listes_meme_longueur_1():
        return decouper_en_listes_meme_longueur([1, 2, 3, 4, 5, 6, 7, 8, 9])\
            == [[1], [2], [3], [4], [5], [6], [7], [8], [9]]
    def test_decouper_en_listes_meme_longueur_2():
        return decouper_en_listes_meme_longueur([1, 2, 3, 4, 5, 6, 7, 8, 9], 4)\
            == [[1, 2, 3, 4], [5, 6, 7, 8], [9]]
    ok_ko(test_nb_occurences, "nb_occurences")
    ok_ko(test_mettre_en_majuscule, "mettre_en_majuscule")
    ok_ko(test_retirer, "retirer")
    ok_ko(test_appliquer_1, "appliquer sans paramatre")
    ok_ko(test_appliquer_2, "appliquer avec paramatre")
    ok_ko(test_decouper_en_listes_meme_longueur_1, "decouper_en_listes_meme_longueur 1")
    ok_ko(test_decouper_en_listes_meme_longueur_2, "decouper_en_listes_meme_longueur 2")
