package examples.hello;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ClientApp {

	public static void main(String[] args) {
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://localhost:8080/Hello");
			WebTarget restTarget = webTarget.path("rest");
			WebTarget helloTarget = restTarget.path("bonjour");
			Invocation.Builder invocationBuilder = helloTarget.request(MediaType.TEXT_PLAIN_TYPE);
			Response response = invocationBuilder.get();
			System.out.println(response.getStatus());
			System.out.println(response.readEntity(String.class));
			System.out.println();

			Invocation.Builder invocationBuilder2 = helloTarget.request(MediaType.TEXT_XML_TYPE);
			response = invocationBuilder2.get();
			System.out.println(response.getStatus());
			System.out.println(response.readEntity(String.class));
			System.out.println();
			
			Invocation.Builder invocationBuilder3 = helloTarget.request(MediaType.TEXT_HTML_TYPE);
			response = invocationBuilder3.get();
			System.out.println(response.getStatus());
			System.out.println(response.readEntity(String.class));
			System.out.println();
			
			
				
			
	}
}
